/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.gui.shells;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import net.miginfocom.swing.MigLayout;
import net.nooj4nlp.controller.DictionaryEditorShell.CheckActionListener;
import net.nooj4nlp.controller.DictionaryEditorShell.ColumnHeaderMouseListener;
import net.nooj4nlp.controller.DictionaryEditorShell.DictionaryEditorShellController;
import net.nooj4nlp.controller.DictionaryEditorShell.EnrichActionListener;
import net.nooj4nlp.controller.DictionaryEditorShell.ExportActionListener;
import net.nooj4nlp.controller.DictionaryEditorShell.SortActionListener;
import net.nooj4nlp.controller.DictionaryEditorShell.TextDocumentListener;
import net.nooj4nlp.controller.DictionaryEditorShell.ViewActionListener;
import net.nooj4nlp.gui.actions.documents.CopyActionListener;
import net.nooj4nlp.gui.actions.documents.CutActionListener;
import net.nooj4nlp.gui.actions.documents.PasteActionListener;
import net.nooj4nlp.gui.actions.documents.SelectAllActionListener;
import net.nooj4nlp.gui.actions.shells.construct.FindReplaceActionListener;
import net.nooj4nlp.gui.actions.shells.control.DictionaryCommandInternalFrameListener;
import net.nooj4nlp.gui.actions.shells.modify.ContextMenuMouseListener;
import net.nooj4nlp.gui.main.Launcher;

public class DictionaryEditorShell
extends JInternalFrame {
    private static final long serialVersionUID = 6264526005284711686L;
    private JTextPane textPane;
    private JPopupMenu popText;
    private JPanel editorPane;
    private JPanel tablePane;
    private JLabel lblnTus;
    private JTable table;
    private JScrollPane tableContainer;
    private JMenuItem mntmCheckFormat;
    private JMenuItem mntmFind;
    private JMenuItem mntmSort;
    private JMenuItem mntmSortBackward;
    private JMenuItem mntmView;
    private JMenuItem mntmEnrich;
    private JMenuItem mntmExport;
    private JMenu mnDictionary;
    private DictionaryEditorShellController controller;

    public DictionaryEditorShell() {
        this.setIconifiable(true);
        this.setMaximizable(true);
        this.setResizable(true);
        this.setClosable(true);
        this.setBounds(100, 100, 750, 550);
        this.setDefaultCloseOperation(0);
        this.editorPane = new JPanel();
        this.tablePane = new JPanel();
        this.getContentPane().setLayout((LayoutManager)new MigLayout("ins 7", "[grow,fill]", "[][grow,fill]"));
        this.editorPane.setLayout((LayoutManager)new MigLayout("ins 7", "[grow,fill,left][200::,right]", "[0!][][grow]"));
        this.tablePane.setLayout((LayoutManager)new MigLayout("ins 7", "[grow,fill]", "[grow,fill]"));
        this.tablePane.setVisible(false);
        this.lblnTus = new JLabel("");
        this.getContentPane().add((Component)this.lblnTus, "wrap,cell 0 0,alignx left,aligny top,growy 0");
        this.getContentPane().add((Component)this.editorPane, "hidemode 3,alignx left,aligny top");
        this.getContentPane().add((Component)this.tablePane, "hidemode 3,pushy,alignx left,aligny top");
        this.popText = this.createPopupMenu();
        this.createEditorPane();
        this.createTablePane();
        this.getContentPane().addMouseListener(new ContextMenuMouseListener(this.popText));
        this.controller = new DictionaryEditorShellController(this.textPane, this, this.lblnTus, this.editorPane, this.tablePane, this.table, this.tableContainer);
        this.addInternalFrameListener(new DictionaryCommandInternalFrameListener(this.controller));
        this.textPane.getDocument().addDocumentListener(new TextDocumentListener(this.controller));
        this.mntmCheckFormat.addActionListener(new CheckActionListener(this.controller));
        this.mntmFind.addActionListener(new FindReplaceActionListener(Launcher.getDesktopPane()));
        this.mntmSort.addActionListener(new SortActionListener(this.controller, false));
        this.mntmSortBackward.addActionListener(new SortActionListener(this.controller, true));
        this.mntmView.addActionListener(new ViewActionListener(this.controller));
        this.mntmEnrich.addActionListener(new EnrichActionListener());
        this.mntmExport.addActionListener(new ExportActionListener(this.controller));
        this.table.getTableHeader().addMouseListener(new ColumnHeaderMouseListener(this.controller));
        this.setSorters();
        this.modifyFont(Launcher.preferences.DFont.getFamily(), Launcher.preferences.DFont.getSize());
        this.mnDictionary = this.createDictionaryMenu();
    }

    private void createEditorPane() {
        JLabel lblLineNo = new JLabel("Ln n");
        lblLineNo.setHorizontalAlignment(4);
        this.editorPane.add((Component)lblLineNo, "flowx,cell 2 1");
        JLabel lblColNo = new JLabel("Col n");
        lblColNo.setHorizontalAlignment(4);
        this.editorPane.add((Component)lblColNo, "cell 2 1,gapleft 30");
        this.textPane = new JTextPane();
        this.textPane.setBorder(BorderFactory.createLoweredBevelBorder());
        this.initializeDefaultFont();
        JPanel noWrapPanel = new JPanel(new BorderLayout());
        noWrapPanel.add(this.textPane);
        JScrollPane scrollPane = new JScrollPane(noWrapPanel);
        this.editorPane.add((Component)scrollPane, "cell 0 2,span 3,grow");
        this.textPane.addMouseListener(new ContextMenuMouseListener(this.popText));
    }

    private void createTablePane() {
        this.table = new JTable(new DefaultTableModel()){
            private static final long serialVersionUID = -5784086340191589971L;

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.table.setShowVerticalLines(false);
        this.table.setShowHorizontalLines(false);
        this.tableContainer = new JScrollPane(this.table);
        this.table.addMouseListener(new ContextMenuMouseListener(this.popText));
        this.tableContainer.addMouseListener(new ContextMenuMouseListener(this.popText));
        this.tablePane.add((Component)this.tableContainer, "grow");
    }

    private void setSorters() {
        TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(this.table.getModel());
        for (int i = 0; i < this.table.getColumnCount(); ++i) {
            sorter.setComparator(i, DictionaryEditorShellController.getComparator());
        }
        this.table.setRowSorter(sorter);
    }

    private JPopupMenu createPopupMenu() {
        JPopupMenu pop = new JPopupMenu();
        this.mntmCheckFormat = new JMenuItem("Check Format");
        pop.add(this.mntmCheckFormat);
        this.mntmFind = new JMenuItem("Find//Replace//Extract//Count");
        pop.add(this.mntmFind);
        this.mntmSort = new JMenuItem("Sort");
        pop.add(this.mntmSort);
        this.mntmSortBackward = new JMenuItem("Sort Backward");
        pop.add(this.mntmSortBackward);
        JSeparator separator_1 = new JSeparator();
        pop.add(separator_1);
        this.mntmView = new JMenuItem("View as Table");
        pop.add(this.mntmView);
        this.mntmEnrich = new JMenuItem("Enrich with NooJ's Lexical Information");
        pop.add(this.mntmEnrich);
        this.mntmExport = new JMenuItem("Export table as CSV file");
        pop.add(this.mntmExport);
        this.mntmExport.setEnabled(false);
        return pop;
    }

    private JMenu createDictionaryMenu() {
        Launcher.mnEdit.setVisible(true);
        JMenuItem mntmCut = Launcher.getTextCommands().get("Cut");
        JMenuItem mntmCopy = Launcher.getTextCommands().get("Copy");
        JMenuItem mntmPaste = Launcher.getTextCommands().get("Paste");
        JMenuItem mntmSelectAll = Launcher.getTextCommands().get("Select All");
        mntmCut.addActionListener(new CutActionListener(this.textPane));
        mntmCopy.addActionListener(new CopyActionListener(this.textPane));
        mntmPaste.addActionListener(new PasteActionListener(this.textPane));
        mntmSelectAll.addActionListener(new SelectAllActionListener(this.textPane));
        JMenu mnDictionary = new JMenu("DICTIONARY");
        this.mntmCheckFormat = new JMenuItem("Check Format");
        mnDictionary.add(this.mntmCheckFormat);
        this.mntmCheckFormat.addActionListener(new CheckActionListener(this.controller));
        this.mntmFind = new JMenuItem("Find//Replace//Extract//Count");
        mnDictionary.add(this.mntmFind);
        this.mntmFind.addActionListener(new FindReplaceActionListener(Launcher.getDesktopPane()));
        this.mntmSort = new JMenuItem("Sort");
        mnDictionary.add(this.mntmSort);
        this.mntmSort.addActionListener(new SortActionListener(this.controller, false));
        this.mntmSortBackward = new JMenuItem("Sort Backward");
        mnDictionary.add(this.mntmSortBackward);
        this.mntmSortBackward.addActionListener(new SortActionListener(this.controller, true));
        JSeparator separator_1 = new JSeparator();
        mnDictionary.add(separator_1);
        this.mntmView = new JMenuItem("View as Table");
        mnDictionary.add(this.mntmView);
        this.mntmView.addActionListener(new ViewActionListener(this.controller));
        JMenuItem mntmEnrich = new JMenuItem("Enrich with NooJ's Lexical Information");
        mnDictionary.add(mntmEnrich);
        mntmEnrich.addActionListener(new EnrichActionListener());
        this.mntmExport = new JMenuItem("Export table as CSV file");
        mnDictionary.add(this.mntmExport);
        this.mntmExport.setEnabled(false);
        this.mntmExport.addActionListener(new ExportActionListener(this.controller));
        return mnDictionary;
    }

    private void initializeDefaultFont() {
        this.modifyFont("Courier New", 14);
    }

    public void modifyFont(String fontFamily, int fontSize) {
        SimpleAttributeSet attr = new SimpleAttributeSet();
        StyleConstants.setFontFamily(attr, fontFamily);
        StyleConstants.setFontSize(attr, fontSize);
        StyleConstants.setForeground(attr, Color.darkGray);
        int textLength = this.textPane.getText().length();
        this.textPane.getStyledDocument().setParagraphAttributes(0, textLength, attr, false);
        this.textPane.repaint();
    }

    public DictionaryEditorShellController getController() {
        return this.controller;
    }

    public JTextPane getTextPane() {
        return this.textPane;
    }

    public JMenuItem getMntmView() {
        return this.mntmView;
    }

    public JMenuItem getMntmCheckFormat() {
        return this.mntmCheckFormat;
    }

    public JMenuItem getMntmFind() {
        return this.mntmFind;
    }

    public JMenuItem getMntmSort() {
        return this.mntmSort;
    }

    public JMenuItem getMntmSortBackward() {
        return this.mntmSortBackward;
    }

    public JMenuItem getMntmExport() {
        return this.mntmExport;
    }

    public JLabel getLblnTus() {
        return this.lblnTus;
    }

    public JMenu getMnDictionary() {
        return this.mnDictionary;
    }
}

